<?php declare(strict_types=1);

namespace Newland\GpsFileParsing\Parser;

use Newland\GpsFileParsing\Helper\XmlFileReader;
use Newland\GpsFileParsing\Model\Point;
use Newland\GpsFileParsing\Model\Track;
use Point as GeometryPoint;

class KmlParser implements Parser
{
    /** @var XmlFileReader */
    private $reader;

    public function __construct(XmlFileReader $reader)
    {
        $this->reader = $reader;
    }

    /**
     * TODO: Handle multiple track segments
     */
    public function extractTrack(string $file): Track
    {
        $track = new Track();
        $fileContents = $this->reader->readAsText($file);
        $geometries = \geoPHP::load($fileContents);
        $points = $geometries->getPoints();

        if (isset($points)) {
            foreach ($points as $point) {
                $point = new Point((float) $point->getY(), (float) $point->getX(), (float) ($point->z() ?? 0));
                $track->addPoint($point);
            }
        }

        return $track;
    }
}
