<?php declare(strict_types = 1);

namespace Newland\GpsFileParsing\Helper;

use Newland\GpsFileParsing\Exception\Exception as GpsFileParsingException;
use Safe\Exceptions\AbstractSafeException;
use function Safe\file_get_contents;
use function Safe\simplexml_load_string;
use function Safe\json_encode;
use function Safe\json_decode;

class XmlFileReader
{
    public function read(string $file): array
    {
        try {
            $fileContents = file_get_contents($file) ?? '';
            $xml = simplexml_load_string($fileContents);
            $json = json_encode($xml);
            return json_decode($json, true);
        } catch (AbstractSafeException $exception) {
            throw new GpsFileParsingException(
                sprintf('Error reading file %s as XML: %s', $file, $exception->getMessage()),
                $exception->getCode(),
                $exception
            );
        }
    }
}
