<?php declare(strict_types = 1);

namespace Newland\GpsFileParsing\Tests\Parser;

use Newland\GpsFileParsing\Helper\XmlFileReader;
use Newland\GpsFileParsing\Parser\KmlParser;
use PHPUnit\Framework\TestCase;

class KmlParserTest extends TestCase
{
    /** @var KmlParser */
    protected $subject;

    public function setUp(): void
    {
        parent::setUp();
        $this->subject = new KmlParser(new XmlFileReader());
    }

    /** @dataProvider provideKmlFiles */
    public function testShouldBeAbleToLoadPointFromKmlFile(string $file): void
    {
        $track = $this->subject->extractTrack($file);
        $this->assertIsArray($track->getPoints());
        $this->assertGreaterThan(0, count($track->getPoints()), 'Should have extracted more than one point');
    }

    public function testDoesNotFailWhenTryingToParseInvalidFile(): void
    {
        $this->subject->extractTrack(__DIR__ . '/../../fixtures/invalid-files/not-xml.txt');
        $this->assertTrue(true);
    }

    public function provideKmlFiles(): array
    {
        $dir = __DIR__ . '/../../fixtures/';
        $data = [];
        foreach (glob($dir . '*.kml') as $file) {
            $name = str_replace([ $dir, '.kml' ], '', $file);
            $data[$name] = [ $file ];
        }
        return $data;
    }
}
