<?php declare(strict_types = 1);

namespace Newland\GpsFileParsing\Tests\Model;

use Newland\GpsFileParsing\Model\Point;
use Newland\GpsFileParsing\Model\Track;
use PHPUnit\Framework\TestCase;

class TrackTest extends TestCase
{

    public function testShouldBeAbleToMakeCalculationsFromPointArray(): void
    {
        $track = new Track();

        $track->addPoint(new Point(7.630552053, 47.59724322, 281.0));
        $track->addPoint(new Point(7.630004882, 47.59774965, 280.0));
        $track->addPoint(new Point(7.629060745, 47.59861059, 281.0));

        $this->assertInstanceOf(Point::class, $track->getHighestPoint());
        $this->assertInstanceOf(Point::class, $track->getLowestPoint());
        $this->assertIsFloat($track->getTrackDistanceKilometers());
        $this->assertIsFloat($track->getDescentMeters());
        $this->assertIsFloat($track->getClimbMeters());
    }

    public function testFindsMinimumElevation(): void
    {
        $track = new Track();
        $track->addPoint(new Point(0.0, 0.0, 1.0));
        $track->addPoint(new Point(0.0, 0.0, 2.0));
        $track->addPoint(new Point(0.0, 0.0, 3.0));
        $this->assertEquals(1.0, $track->getLowestPoint()->getElevation());
    }

    public function testFindsMaximumElevation(): void
    {
        $track = new Track();
        $track->addPoint(new Point(0.0, 0.0, 1.0));
        $track->addPoint(new Point(0.0, 0.0, 2.0));
        $track->addPoint(new Point(0.0, 0.0, 3.0));
        $this->assertEquals(3.0, $track->getHighestPoint()->getElevation());
    }
}
