<?php declare(strict_types = 1);

namespace Newland\GpsFileParsing\Parser;

use Newland\GpsFileParsing\Helper\XmlFileReader;
use Newland\GpsFileParsing\Model\Point;
use Newland\GpsFileParsing\Model\Track;

class GpxParser implements Parser
{
    /** @var XmlFileReader */
    private $reader;

    public function __construct(XmlFileReader $reader)
    {
        $this->reader = $reader;
    }

    public function extractTrack(string $file): Track
    {
        $data = $this->reader->read($file);

        $track = new Track();
        $this->parseTrackSegments($data, $track);
        $this->parseRoutePoints($data, $track);

        return $track;
    }

    private function parseTrackSegments(array $data, Track $track): void
    {
        // incoming data can either be
        // { 'trkseg': { 'trkpt': [ ... ] } }
        // or
        // { 'trkseg': [ { 'trkpt': [ ... ] }, { 'trkpt': [ ... ] } ] }
        $singleSegmentPoints = $data['trk']['trkseg']['trkpt'] ?? null;
        if ($singleSegmentPoints) {
            $segments = [ [ 'trkpt' => $singleSegmentPoints ] ];
        } else {
            $segments = $data['trk']['trkseg'] ?? [];
        }

        foreach ($segments as $segment) {
            foreach ($segment['trkpt'] as $trackPoint) {
                $point = new Point(
                    (float) $trackPoint['@attributes']['lat'],
                    (float) $trackPoint['@attributes']['lon'],
                    (float) $trackPoint['ele']
                );
                $track->addPoint($point);
            }
        }
    }

    private function parseRoutePoints(array $data, Track $track): void
    {
        foreach ($data['rte']['rtept'] ?? [] as $trackPoint) {
            $point = new Point(
                (float) $trackPoint['@attributes']['lat'],
                (float) $trackPoint['@attributes']['lon'],
                (float) $trackPoint['ele']
            );
            $track->addPoint($point);
        }
    }
}
