# Neos Frontend Login

This package is based on https://github.com/Flowpack/Flowpack.Neos.FrontendLogin and provides a frontend login as commonly used in our projects.

## Integration

### Setup
To integrate this package into your project, simply add it to your **project** `composer.json`. To ensure that loading order (e.g. for configurations) is correct, also add it to your **site package** `composer.json`.

### Routing
This package comes with pre-configured routes. You need to add the following configuration to your **project** `Configuration/Routes.yaml`:
```
-
  name: 'FrontendLogin'
  uriPattern: '<FrontendLoginSubroutes>'
  subRoutes:
    'FrontendSubroutes':
      package: 'Newland.FrontendLogin.Neos'
```

### Log-in
This package provides a `Frontend Log-In` node type that you will find under the `Plugins` section. Simply add it to a page to provide a log-in.

### Users
This package comes with its own authentication provider and role. You can create users in the "User Management" module in the Neos CMS back-end. Make sure the user has the correct role (which is `FrontendUser`) and the correct authentication provider (which is `Newland.FrontendLogin.Neos:Frontend`).

### Translations
To change translations, you need to tell the package the package name and source file of your translations. To do this, add the following to your `Settings.yaml`:
```
Newland:
  FrontendLogin:
    Neos:
      translation:
        packageKey: 'Newland.YourTheme'
        sourceName: 'Views/FrontendLogin'
```
The example configuration above assumes that the file
`Packages/Sites/Newland.YourTheme/Resources/Private/Translations/en/Views/FrontendLogin.xlf` exists.

### Templates
To override templates, you need to add a request filter to your **site package** `Views.yaml`:
```
-
  requestFilter: 'isPackage("Newland.FrontendLogin.Neos") && isController("Authentication") && isAction("show")'
  options:
    templatePathAndFilename: 'resource://Newland.YourTheme/Private/Templates/Authentication/Show.html'
```
