<?php
namespace Newland\FrontendLogin\Neos\Mailer;

/*
 * This file is part of the "frontendlogin-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\View\StandaloneView;
use Neos\Flow\Annotations as Flow;
use Neos\SwiftMailer\Message;

/**
 * Access request mailer class.
 *
 * @Flow\Scope("singleton")
 */
class AccessRequestMailer
{
    /**
     * @Flow\InjectConfiguration
     * @var array
     */
    protected $configuration;

    /**
     * Delivers given credentials to given email address.
     *
     * @param array $accessRequest
     * @param string $senderAddress
     * @param string $subject
     * @param string $username
     * @param string $password
     * @return void
     */
    public function deliverCredentials($accessRequest, $senderAddress, $subject, $username, $password)
    {
        $view = $this->createStandaloneView(
            'AccessRequestMailer/Credentials',
            [
                'username' => $username,
                'password' => $password
            ]
        );

        $message = new Message;
        $message->setTo([$accessRequest['email']])
                ->setFrom([$senderAddress])
                ->setSubject($subject)
                ->setBody($view->render(), 'text/html');

        $message->send();
    }

    /**
     * Creates a fluid standalone view.
     *
     * @param string $template Path to the template to render.
     * @return StandaloneView
     */
    protected function createStandaloneView($template, $variables = [])
    {
        $view = new StandaloneView;
        $view->setTemplateRootPaths(
            $this->configuration['accessRequestMailer']['templateRootPaths']
        );
        $view->setTemplate($template);
        $view->assignMultiple($variables);
        return $view;
    }
}
