<?php
namespace Newland\FrontendLogin\Neos\Controller;

/*
 * This file is part of the "frontendlogin-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\Mvc\ActionRequest;
use Neos\Flow\Mvc\View\ViewInterface;
use Neos\Flow\Security\Authentication\Controller\AbstractAuthenticationController;
use Neos\Flow\Security\Exception\AuthenticationRequiredException;

/**
 * Authentication controller.
 */
class AuthenticationController extends AbstractAuthenticationController
{
    /**
     * @return void
     */
    public function showAction()
    {
        $this->view->assignMultiple([
            'account' => $this->securityContext->getAccount(),
            'redirectAfterLoginUri' => $this->request->getInternalArgument('__redirectAfterLoginUri'),
            'redirectAfterLogoutUri' => $this->request->getInternalArgument('__redirectAfterLogoutUri'),
            'redirectAfterAuthenticationFailureUri' => $this->request->getInternalArgument('__redirectAfterAuthenticationFailureUri'),
            'loginError' => (isset($_GET['failure']) ? (bool)$_GET['failure'] : false)
        ]);
    }

    /**
     * @return string
     * @Flow\SkipCsrfProtection
     */
    public function authenticateAction()
    {
        return parent::authenticateAction();
    }

    /**
     * @return void
     */
    public function logoutAction()
    {
        parent::logoutAction();
        $arguments = $this->request->getInternalArgument('__authentication');
        $this->redirectToUri($arguments['redirectAfterLogoutUri']);
    }

    /**
     * @param ActionRequest $originalRequest The request that was intercepted by the security framework
     * @return void
     * @Flow\SkipCsrfProtection
     */
    protected function onAuthenticationSuccess(ActionRequest $originalRequest = null)
    {
        $arguments = $this->request->getInternalArgument('__authentication');
        $this->redirectToUri($arguments['redirectAfterLoginUri']);
    }

    /**
     * Is called if authentication failed.
     *
     * Override this method in your login controller to take any
     * custom action for this event. Most likely you would want
     * to redirect to some action showing the login form again.
     *
     * @param AuthenticationRequiredException $exception The exception thrown while the authentication process
     * @return void
     */
    protected function onAuthenticationFailure(AuthenticationRequiredException $exception = null)
    {
        $arguments = $this->request->getInternalArgument('__authentication');
        $this->redirectToUri(
            $arguments['redirectAfterAuthenticationFailureUri'] . '?failure=1'
        );
    }

    /**
     * Disable the technical error flash message.
     *
     * @return boolean
     */
    protected function getErrorFlashMessage()
    {
        return false;
    }
}
