<?php
namespace Newland\FrontendLogin\Neos\Controller;

/*
 * This file is part of the "frontendlogin-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\Mvc\Controller\ActionController;
use Newland\FrontendLogin\Neos\Mailer\AccessRequestMailer;

/**
 * Access request controller.
 *
 * Responsible for handling requests for authentication access
 * (e.g. login credentials).
 */
class AccessRequestController extends ActionController
{
    /**
     * @Flow\Inject
     * @var AccessRequestMailer
     */
    protected $accessRequestMailer;

    /**
     * New action.
     *
     * Displays a form to submit an access request.
     *
     * @return void
     */
    public function newAction()
    {
    }

    /**
     * Create action.
     *
     * Processes the submitted access request params.
     *
     * @param array $accessRequest
     * @return void
     */
    public function createAction(array $accessRequest = [])
    {
        if (empty($accessRequest['email'])) {
            return $this->redirect('new');
        }

        $this->emitBeforeDeliveringCredentials($accessRequest);

        $this->accessRequestMailer->deliverCredentials(
            $accessRequest,
            $this->request->getInternalArgument('__senderAddress'),
            $this->request->getInternalArgument('__subject'),
            $this->request->getInternalArgument('__username'),
            $this->request->getInternalArgument('__password')
        );

        $this->redirectToUri(
            $this->request->getInternalArgument('__redirectAfterSubmission')
        );
    }

    /**
     * Signal stub to modify the access request before API submission.
     *
     * @param array &$accessRequest
     * @return void
     * @Flow\Signal
     */
    protected function emitBeforeDeliveringCredentials(array &$accessRequest)
    {}
}
