<?php
namespace Newland\Curator\Neos\Controller;

/*
 * This file is part of the "curator-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\View\StandaloneView;
use Neos\Flow\Mvc\Controller\ActionController;
use Neos\Flow\Mvc\View\ViewInterface;
use Newland\Curator\Neos\Service\ApiService;

/**
 * Abstract action controller.
 *
 * @Flow\Scope("singleton")
 */
abstract class AbstractActionController extends ActionController
{
    /**
     * @var Node The current node.
     */
    protected $node;

    /**
     * @var array
     */
    protected $properties;

    /**
     * @Flow\Inject
     * @var ApiService
     */
    protected $apiService;

    /**
     * Action initializer.
     *
     * Called before the called action. This may be called
     * manually inside an action that is working outside of
     * the default node/context, like an AJAX action.
     *
     * @param Node|null $node
     * @return void
     */
    protected function initializeAction(Node $node = null)
    {
        if ($node) {
            $this->node = $node;
        } else {
            $this->node = $this->request->getInternalArgument('__node');

        }

        if (!$this->node) {
            return;
        }

        $this->properties = $this->node->getProperties();
    }

    /**
     * View initializer.
     *
     * Called before a view is rendered.
     *
     * @param ViewInterface $view
     * @return void
     */
    protected function initializeView(ViewInterface $view)
    {
        $view->assignMultiple([
            'node' => $this->node,
            'properties' => $this->properties
        ]);
    }
}
