<?php
namespace Newland\Curator\Neos\Service;

/*
 * This file is part of the "curator-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;

/**
 * API Service class.
 *
 * @see https://curator.io/docs/api/getting-started/index
 */
class ApiService
{
    /**
     * @var string Base URI for requests.
     */
    const BASE_URI = 'https://api.curator.io/v1/';

    /**
     * @Flow\InjectConfiguration
     * @var array
     */
    protected $configuration;

    /**
     * Gets all available feeds.
     *
     * @return array|null
     */
    public function getFeeds()
    {
        return $this->request('feeds');
    }

    /**
     * Gets posts from a given feed.
     *
     * @param string $feedId
     * @param array $options
     * @return array|null
     */
    public function getFeedPosts($feedId, $options = [])
    {
        $data = $this->request('feeds/' . $feedId . '/posts', $options);
        return $data['posts'];
    }

    /**
     * Sends a request to the endpoint.
     *
     * @param string $path
     * @param array $options
     * @return array|null
     */
    protected function request($path, $options = [])
    {
        $httpClient = new \GuzzleHttp\Client([
            'base_uri' => static::BASE_URI,
            'auth' => [
                $this->configuration['apiKey'], null, 'Basic'
            ]
        ]);
        $response = $httpClient->request('GET', $path, ['query' => $options]);
        if ($response->getStatusCode() == 200) {
            return json_decode($response->getBody(), true);
        } else {
            return null;
        }
    }
}
