<?php
namespace Newland\Curator\Neos\DataSource;

/*
 * This file is part of the "curator-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Neos\Service\DataSource\AbstractDataSource;
use Newland\Curator\Neos\Service\ApiService;

/**
 * Feeds data source.
 *
 * Fetches configured feeds.
 *
 * @Flow\Scope("singleton")
 */
class FeedsDataSource extends AbstractDataSource
{
    /**
     * @var string Data source identifier.
     */
    static protected $identifier = 'newland-curator-neos-feeds';

    /**
     * @var ApiService
     * @Flow\Inject
     */
    protected $apiService;

    /**
     * Get data
     *
     * The return value must be JSON serializable data structure.
     *
     * @param NodeInterface $node The node that is currently edited (optional)
     * @param array $arguments Additional arguments (key / value)
     * @return mixed JSON serializable data
     * @api
     */
    public function getData(NodeInterface $node = null, array $arguments)
    {
        $feeds = [];
        $data = $this->apiService->getFeeds();
        foreach ($data as $entry) {
            $feeds[] = [
                'value' => $entry['id'],
                'label' => $entry['name']
            ];
        }
        return $feeds;
    }
}
