<?php
namespace Newland\Curator\Neos\Controller;

/*
 * This file is part of the "curator-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;

/**
 * Outputs controller.
 *
 * Responsible for outputting data from curator.io.
 *
 * @Flow\Scope("singleton")
 */
class OutputsController extends AbstractActionController
{
    /**
     * Index action.
     *
     * Default action for displaying a full social media wall.
     *
     * @return void
     */
    public function indexAction()
    {
        $this->view->assign('posts', $this->apiService->getFeedPosts($this->properties['feed']));
    }

    /**
     * Teaser action.
     *
     * Similar to the index action, but only lists a subset of
     * available records without any other features.
     *
     * @return void
     */
    public function teaserAction()
    {
        $this->view->assign(
            'posts',
            $this->apiService->getFeedPosts(
                $this->properties['feed'],
                [
                    'limit' => (int)$this->properties['limit']
                ]
            )
        );
    }
}
