<?php declare(strict_types=1);
namespace Newland\Contracts\Neos\Filter;

/*
 * This file is part of the "neos-filtering" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Marks a filter item as query bound:
 * These filter items add something to the query string if they are active
 * and allow data to be carried through the query string.
 *
 * @see HasQueryString for a default implementation
 */
interface QueryBoundFilterItem extends FilterItem
{

    /**
     * Sets the query string under which the item should be available.
     * This must be unique on a page and will determine which GET parameters are added to the URL.
     *
     * @param string $queryString
     */
    public function setQueryString(string $queryString): void;

    public function getQueryString(): ?string;

    public function getQueryForOverrides(array $overrides): array;
}
