<?php declare(strict_types=1);

namespace Newland\Contracts\Neos\Search;

class IndexRecordModification
{
    /** @var string */
    protected $identifier;

    /** @var string */
    protected $title;

    /** @var string */
    protected $description;

    /** @var string */
    protected $content;

    /** @var string|null */
    protected $scope;

    /** @var string|null */
    protected $language;

    public function __construct(
        string $identifier,
        string $title,
        string $description,
        string $content,
        ?string $scope,
        ?string $language
    ) {
        $this->identifier = $identifier;
        $this->title = $title;
        $this->description = $description;
        $this->content = $content;
        $this->scope = $scope;
        $this->language = $language;
    }

    public function getIdentifier(): string
    {
        return $this->identifier;
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    public function getDescription(): string
    {
        return $this->description;
    }

    public function getContent(): string
    {
        return $this->content;
    }

    public function getScope(): ?string
    {
        return $this->scope;
    }

    public function getLanguage(): ?string
    {
        return $this->language;
    }
}
