<?php declare(strict_types=1);

namespace Newland\Contracts\Neos\Search;

class SearchResult extends IndexRecordModification
{
    /** @var mixed */
    protected $rawResult;

    /** @var string */
    protected $source = '';

    /** @var float */
    protected $score = 0.0;

    public function __construct(
        string $identifier,
        string $title,
        string $description,
        string $content,
        ?string $scope,
        ?string $language,
        string $source,
        float $score = 0.0,
        $rawResult = null
    ) {
        parent::__construct($identifier, $title, $description, $content, $scope, $language);
        $this->source = $source;
        $this->score = $score;
        $this->rawResult = $rawResult;
    }

    public function getSource(): string
    {
        return $this->source;
    }

    public function getScore(): float
    {
        return $this->score;
    }

    public function getRawResult()
    {
        return $this->rawResult;
    }
}
