<?php declare(strict_types=1);

namespace Newland\Contracts\Neos\Search;

class SuggestRequest
{
    /** @var string */
    protected $searchTerm;

    /** @var string */
    protected $fieldName;

    /** @var int */
    protected $limit;

    /** @var string */
    protected $language;

    public function __construct(
        string $searchTerm,
        string $fieldName,
        string $language,
        int $limit = 10
    ) {
        $this->searchTerm = $searchTerm;
        $this->fieldName = $fieldName;
        $this->language = $language;
        $this->limit = $limit;
    }

    public function getSearchTerm(): string
    {
        return $this->searchTerm;
    }

    public function getFieldName(): string
    {
        return $this->fieldName;
    }

    public function getLimit(): int
    {
        return $this->limit;
    }

    public function getLanguage(): string
    {
        return $this->language;
    }
}
