<?php declare(strict_types=1);

namespace Newland\Contracts\Neos\Search;

interface SearchBackend
{

    public function initialize(): void;

    /**
     * Sets the name of the source the backend is currently operating on.
     * All operations after this call will assume to operate on the given source.
     * This is done in order to differentiate multiple indexers: Calling `createOrUpdateIndexEntry`
     * with the same identifier but different sources should still create 2 different index entries
     * since the entries come from different indexers.
     *
     * @param string $source
     */
    public function setSource(string $source): void;

    public function createOrUpdateIndexEntry(IndexRecordModification $modification): void;

    public function afterIndexing(): void;

    /**
     * Deletes old / outdated index entries from the given source from the backend.
     * This method should remove all entries from the given source that is not present in the
     * `indentifiersToRetain` array from the backend in order to ensure that only up-to-date
     * records are in the index.
     *
     * @param string[] $identifiersToRetain
     */
    public function deleteObsoleteIndexEntries(array $identifiersToRetain): void;

    public function search(SearchRequest $request): SearchResultCollection;

    public function suggest(SuggestRequest $request): array;
}
