<?php declare(strict_types=1);

namespace Newland\Contracts\Neos\Filter;

interface ProvidesHiddenFieldsIfObstructed
{
    /**
     * Returns an array of hidden fields as an associative array.
     * These fields will be prepended to the form body if the current item is obstructed
     * (i.e. 'hidden in frontend'). This can be used to still preserve the form state
     * even if the item is not actually rendered to the page.
     *
     * @return string[]
     */
    public function getHiddenFieldsIfObstructed(): array;
}
