<?php declare(strict_types=1);
namespace Newland\Contracts\Neos\Filter;

/*
 * This file is part of the "neos-filtering" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Simple DTO that is being used to transport information about the returned
 * expression of a filter item.
 */
class Expression
{
    /** @var mixed|null */
    public $where;

    /** @var mixed|null */
    public $having;

    /** @param mixed $where */
    public static function where($where): Expression
    {
        $expression = new Expression();
        $expression->where = $where;
        return $expression;
    }

    /** @param mixed $where */
    public static function having($where): Expression
    {
        $expression = new Expression();
        $expression->having = $where;
        return $expression;
    }

    public static function empty(): Expression
    {
        return new Expression();
    }
}
