<?php declare(strict_types=1);
namespace Newland\Contracts\Neos\Filter;

/*
 * This file is part of the "neos-filtering" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Interface that must be implemented by filter items if they have children and that in turn
 * display the full extent of the filter.
 */
interface CompositeFilterItem extends FilterItem
{
    public function addItem(FilterItem $item): void;

    /** @return FilterItem[] */
    public function getChildrenItems(): array;
}
