<?php declare(strict_types=1);

namespace Newland\Contracts\Neos\Search;

use Doctrine\Common\Collections\ArrayCollection;

/**
 * @extends ArrayCollection<int, SearchResult>
 */
class SearchResultCollection extends ArrayCollection
{
    /** @var int */
    protected $numberOfResults;

    public function __construct(int $numberOfResults)
    {
        parent::__construct();
        $this->numberOfResults = $numberOfResults;
    }

    public function getNumberOfResults(): int
    {
        return $this->numberOfResults;
    }
}
