<?php declare(strict_types=1);

namespace Newland\Contracts\Neos\Search;

class IndexRecordModification
{
    /** @var string */
    protected $identifier;

    /** @var string */
    protected $title;

    /** @var string */
    protected $description;

    /** @var string */
    protected $content;

    /** @var string[] */
    protected $scopes;

    /** @var string */
    protected $type;

    /** @var string|null */
    protected $language;

    public function __construct(
        string $identifier,
        string $type,
        string $title,
        string $description,
        string $content,
        array $scopes,
        ?string $language
    ) {
        $this->identifier = $identifier;
        $this->type = $type;
        $this->title = $title;
        $this->description = $description;
        $this->content = $content;
        $this->scopes = $scopes;
        $this->language = $language;
    }

    public function getIdentifier(): string
    {
        return $this->identifier;
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    public function getDescription(): string
    {
        return $this->description;
    }

    public function getContent(): string
    {
        return $this->content;
    }

    public function getScopes(): array
    {
        return $this->scopes;
    }

    public function getLanguage(): ?string
    {
        return $this->language;
    }

    public function getType(): string
    {
        return $this->type;
    }
}
