<?php declare(strict_types=1);

namespace Newland\Contracts\Neos\Filter;

use Doctrine\ORM\QueryBuilder;
use Neos\ContentRepository\Domain\Model\NodeInterface;
use TYPO3Fluid\Fluid\Core\Rendering\RenderableInterface;

/**
 * The root object of a whole filter.
 * Additionally to rendering the frame around a filter this class has a bit more
 * functionality:
 *
 * - Applies the expressions returned by it's children to a given query builder.
 * - Maintains a mapping of query string => filter item which is used to set the state on
 *   it's children.
 */
interface FilterRoot extends FilterItem
{
    public function getResultCount(QueryBuilder $query): int;

    public function applyToQuery(QueryBuilder $query): QueryBuilder;

    public function getStatusIndicators(): RenderableInterface;

    public function getPluginNode(): ?NodeInterface;

    public function addHiddenFields(array $fields): void;

    public function setActionUri(string $actionUri): void;

    /**
     * @param string[] $templateRootPaths
     * @param string[] $layoutRootPaths
     * @param string[] $partialRootPaths
     */
    public function addTemplateRootPaths(
        array $templateRootPaths = [],
        array $layoutRootPaths = [],
        array $partialRootPaths = []
    ): void;
}
