<?php declare(strict_types=1);

namespace Newland\Contracts\Neos\Search;

class SearchRequest
{
    /** @var string */
    protected $searchTerm;

    /** @var int */
    protected $itemsPerPage;

    /** @var int */
    protected $page;

    /** @var string */
    protected $language;

    /** @var string[] */
    protected $scopes;

    public function __construct(
        string $searchTerm,
        string $language,
        array $scopes,
        int $itemsPerPage = 10,
        int $page = 1
    ) {
        $this->searchTerm = $searchTerm;
        $this->itemsPerPage = $itemsPerPage;
        $this->page = $page;
        $this->language = $language;
        $this->scopes = $scopes;
    }

    public function getSearchTerm(): string
    {
        return $this->searchTerm;
    }

    public function getItemsPerPage(): int
    {
        return $this->itemsPerPage;
    }

    public function getPage(): int
    {
        return $this->page;
    }

    public function getLanguage(): string
    {
        return $this->language;
    }

    /** @return string[] */
    public function getScopes(): array
    {
        return $this->scopes;
    }
}
