module.exports = context => ({
    map: context.env === 'development' ? context.map : false,
    plugins: {
        /*
         *  tailwindcss plugin, uses configuration defined
         *  in tailwind.config.js
         */
        'tailwindcss': './tailwind.config.js',

        /*
         *  This plugin doesn't need configuration.
         *  It should be used together with object-fit-images
         *  polyfill (https://github.com/bfred-it/object-fit-images).
         *  https://github.com/ronik-design/postcss-object-fit-images
         */
        'postcss-object-fit-images': {},

        /*
         *  autoprefixer plugin, uses browser configuration
         *  from .browserslistrc. See https://github.com/postcss/autoprefixer
         *  for more available settings.
         */
        'autoprefixer': {},

        /*
         *  cssnano plugin for bundle optimization/minification
         *  while in production mode.
         *  See https://cssnano.co/guides/presets for
         *  available settings/presets.
         */
        'cssnano': context.env === 'development' ? false : {
            preset: 'default',
        },
    },
});
