import { onPageLoadComplete } from '@nimius/event-utility';

const hideBodyOverflow = () => {

    const html = document.querySelector('body');
    const overlays = document.querySelectorAll('.c-overlay, .c-main-menu');

    /*
    * Watch if an overlay is shown by listening for change of the class attribute
    * and check if the `is-target` attribtute is set (done via target enhancements)
    */
    const observer = new MutationObserver(mutations => {
        for (const mutation of mutations) {
            if (mutation.target.className.includes('is-target')) {
                html.classList.add('has-overlay');
            } else {
                html.classList.remove('has-overlay');
            }
        }
    });

    for (const overlay of overlays) {
        observer.observe(overlay, { attributes: true, attributeFilter: [ 'class' ], childList: false, subtree: false });
    }
};

onPageLoadComplete(() => {
    hideBodyOverflow();
});
