/* eslint-disable */
import { onPageLoadComplete } from '@nimius/event-utility';
import flatpickr from 'flatpickr';
// https://github.com/flatpickr/flatpickr/tree/master/src/l10n
import { english } from 'flatpickr/dist/l10n/default.js';
import { German } from 'flatpickr/dist/l10n/de.js';
import { Italian } from 'flatpickr/dist/l10n/it.js';
import { French } from 'flatpickr/dist/l10n/fr.js';
import { Dutch } from 'flatpickr/dist/l10n/nl.js';
import { flatpickrToToubizDatepickerAdapter } from '@newland/assets-neos/Products/date-picker/adaptor/flatpickr';

const initFlatpickrs = () => {
    const datePickerContainers = document.querySelectorAll('[data-flatpickr-container]');

    if (datePickerContainers.length > 0) {
        const flatpickrLanguage = datePickerContainers[0].getAttribute('data-flatpickr-lang');
        // Set default language
        let dateLocale = German;
        // Check if data attribute is in dom and set new language
        if(flatpickrLanguage) {
            dateLocale = flatpickrLanguage;
        }

        for (const datePicker of datePickerContainers) {
            const dateInputFrom = datePicker.querySelector('[data-flatpickr\\.from]');
            const dateInputTo = datePicker.querySelector('[data-flatpickr\\.to]');
            const dateUnknown = datePicker.querySelector('[data-flatpickr\\.form-param]');

            if (dateInputTo && dateInputFrom && dateUnknown) {
                const dateInputToInstance = dateInputTo.flatpickr({
                    dateFormat: 'd.m.Y',
                    disableMobile: true,
                    locale: dateLocale,
                    clickOpens: false,
                });

                const dateInputFromInstance = dateInputFrom.flatpickr({
                    dateFormat: 'd.m.Y',
                    disableMobile: true,
                    locale: dateLocale,
                    minDate: 'today',
                    clickOpens: false,
                    onChange: function (selectedDates) {
                        const newToDate = selectedDates[0].fp_incr(1);
                        dateInputTo.value = newToDate;
                        dateInputToInstance.set('minDate', newToDate);
                        dateInputToInstance.setDate(newToDate);
                        dateInputToInstance.open();
                        if (dateUnknown) {
                            dateUnknown.remove();
                        }
                    },
                });

                /**
                 * https://github.com/flatpickr/flatpickr/issues/923
                 * There is a known bug on touchdevices where the flatpickr with the build in open
                 * function fires open and close event the same time. To fix this set `clickOpens: false` and use custom
                 * event handler for `click` and `touchstart`.
                 */

                const openWithInputFrom = () => {
                    dateInputFromInstance.open();
                };

                const openWithInputTo = () => {
                    dateInputToInstance.open();
                };

                dateInputFrom.addEventListener('click', openWithInputFrom, false);
                dateInputFrom.addEventListener('touchstart', openWithInputFrom, false);
                dateInputTo.addEventListener('click', openWithInputTo, false);
                dateInputTo.addEventListener('touchstart', openWithInputTo, false);

                flatpickrToToubizDatepickerAdapter(datePicker, dateInputFrom, dateInputTo);
            }
        }
    }
};

onPageLoadComplete(() => initFlatpickrs());
