import { onPageLoadComplete } from '@nimius/event-utility';

onPageLoadComplete(() => {
    const closeButtons = document.querySelectorAll('[data-overlay-close]');
    const liveOverlayTrigger = document.querySelector('[data-live-overlay-trigger]');
    const liveMenuTrigger = document.querySelector('[data-live-menu-trigger]');

    for (const closeButton of closeButtons) {
        closeButton.addEventListener("click", function() {
            liveOverlayTrigger.setAttribute('aria-expanded', 'false');
            liveMenuTrigger.setAttribute('aria-expanded', 'false');
        }, false);
    }
});
