<?php
namespace Newland\CityTheme\ViewHelpers;

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
use Neos\Flow\Annotations as Flow;
use Neos\Neos\Service\UserService;
use Neos\Neos\Domain\Service\UserService as DomainUserService;
use Neos\Neos\Domain\Model\User;


class UserNameViewHelper extends AbstractViewHelper {
    /**
     * @Flow\Inject
     * @var \Neos\Neos\Domain\Service\UserService
     */
    protected $userDomainService;

    /**
     * Render user name.
     * @return string
     * @throws \Neos\Neos\Domain\Exception
     */
    public function render()
    {
        $currentUser = $this->userDomainService->getCurrentUser();

        if (!$currentUser instanceof User) {
            return null;
        }

        $username = $this->userDomainService->getUsername($currentUser);
        return $username;
    }
}