import { onPageLoadComplete } from '@nimius/event-utility';

const initSearchFocus = () => {
    const searchFocusTrigger = document.querySelector('[data-search-focus-trigger]');
    const searchFocusTarget = document.querySelector('[data-search-focus-target]');

    if (searchFocusTrigger && searchFocusTarget) {
        searchFocusTrigger.addEventListener('click', () => {
            if (searchFocusTrigger.getAttribute('aria-expanded') == 'false') {
                setTimeout(() => {
                    searchFocusTarget.focus();
                }, 1);
            }
        });
    }
};

onPageLoadComplete(() => {
    initSearchFocus();
});
