/**
    Modern Fontloading approach
    This is an example configuration!

    This script must be placed in a partial, which is then rendered
    inline in the <head> section of the default.html template.
 */
(function() {
    "use strict";

    // If fonts have been downloaded and cached we can swap them in immediately.
    if( sessionStorage.fontsLoaded ) {
        document.documentElement.className += " fonts-loaded-1 fonts-loaded-2";
        return;
    // If the FontLoading API is supported, we use that modern approach to load our fonts.
    } else if( "fonts" in document ) {
        // We load a single webfont first and after it's been loaded
        document.fonts.load("400 1em FontFamilyXName").then(function () {
            // we set a class on the <html> element.
            document.documentElement.className += " fonts-loaded-1";
            // Then we load all the other fonts or variants thereof
            Promise.all([
                // This is a different font altogether
                document.fonts.load("400 1m FontFamilyYName"),
                // This is a bold variant of the first
                document.fonts.load("700 1em FontFamilyXName"),
                // This is an italic variant of the first
                document.fonts.load("400 italic 1em FontFamilyXName")
            ]).then(function () {
                // And set a second class
                document.documentElement.className += " fonts-loaded-2";
                // while writing to the sessionStorage
                sessionStorage.fontsLoaded = true;
            });
        });
    // No FontLoading API support (Early Edge, IE11 and below) will result in a legacy approach.
    } else {
        var ref = document.getElementsByTagName( "script" )[ 0 ];
        var script = document.createElement( "script" );
        // Adjust this path to match with the actual path in your project.
        script.src = "/_Resources/Static/Packages/Newland.BaseTheme/Scripts/legacy-fontloading/fontloading-legacy.js";
        script.async = true;
        ref.parentNode.insertBefore( script, ref );
    }
})();
