import { AbstractTargetEnhancementPlugin, dependencyInjectionContainer } from '@nimius/target-enhancement';
import { fireEvent } from '@nimius/event-utility';

/**
 * @description Plugin/Extension for target enhancement that synchronizes multiple toggle elements.
 */
export default class TargetEnhancementTriggerBindPlugin extends AbstractTargetEnhancementPlugin {

    // eslint-disable-next-line no-unused-vars
    initialize (element, targets, options = {}) {
        if (!options.selector) {
            console.warn('## Target Enhancement: Option "selector" is required for trigger-bind plugin.');
            return;
        }

        const boundElements = document.querySelectorAll(options.selector);

        element.addEventListener('target-enhancement.open', () => {
            for (const boundElement of boundElements) {
                fireEvent(boundElement, 'target-enhancement.open');
            }
        });

        element.addEventListener('target-enhancement.close', () => {
            for (const boundElement of boundElements) {
                fireEvent(boundElement, 'target-enhancement.close');
            }
        });
    }

}

// Add to dependency injection container.
// This makes the plugin available via `data-target-enhancement-plugins.{INT}.name="hello-world"`
dependencyInjectionContainer.provide('trigger-bind', () => new TargetEnhancementTriggerBindPlugin());
