import { onPageLoadComplete } from '@nimius/event-utility';

const initScrollCheck = () => {
    let debounceTimer;
    const siteHeaderFillClass = 'c-site-header--filled';
    const siteHeader = document.querySelector('[data-site-header-transparent]');

    if (siteHeader) {
        window.addEventListener('scroll', () => {
            if (debounceTimer) {
                clearTimeout(debounceTimer);
            }

            debounceTimer = setTimeout(() => {
                const scrolledY = window.scrollY;

                if (scrolledY > 50) {
                    siteHeader.classList.add(siteHeaderFillClass);
                } else {
                    siteHeader.classList.remove(siteHeaderFillClass);
                }
            }, 200);
        });
    }
};

onPageLoadComplete(() => {
    initScrollCheck();
    // Fire scroll event once, to check if window.scrollY is higher than 50 on pageload
    window.dispatchEvent(new Event('scroll'));
});
