import { onPageLoadComplete } from '@nimius/event-utility';

const tourenIframe = document.getElementById("touren-iframe");

onPageLoadComplete(() => {
    if (tourenIframe) {
        if (window.attachEvent && !window.addEventListener) {
            window.addEventListener = function (evt, f) {
                window.attachEvent("on" + evt, f);
            };
        }

        window.addEventListener("message", function (event) {

            if (!event.data) {
                return;
            }

            const m = event.data.match(/frameworkextern\.iframeresize\?height=(\d+)/);

            if (m) {
                let h = parseInt(m[1]) + 250;

                if (h < 600) {
                    h = 600;
                }

                //$("#touren-iframe").height(h+"px");

                tourenIframe.style.height = h + 'px';
            }

        }, false);
    }
});