<?php
declare(strict_types=1);
namespace Newland\CityTheme\Form\Html\Html;

use Neos\Flow\Property\PropertyMappingConfiguration;
use Neos\Flow\ResourceManagement\PersistentResource;
use Neos\Flow\Validation\Exception\InvalidValidationOptionsException;
use Neos\Form\Core\Model\AbstractFormElement;
use Neos\Form\Core\Runtime\FormRuntime;
use Neos\Form\Exception\FormDefinitionConsistencyException;
use Neos\Form\Validation\FileTypeValidator;

/**
 * A Neos.Form Element that represents a multiple file upload
 * The resulting form value is an array of PersistentResource instances
 */
final class Html extends AbstractFormElement
{

    /**
     * @return void
     */
    public function initializeFormElement()
    {
        $this->setDataType('array<' . PersistentResource::class . '>');
    }
}
