/* eslint-disable */
import { onPageLoadComplete } from '@nimius/event-utility';

// format given date object in Y-m-d format
const formatDate = (date) => {
    const year = date.getFullYear();
    const month = String(date.getMonth() + 1).padStart(2, '0'); // Ensure 2 digits
    const day = String(date.getDate()).padStart(2, '0');
    return `${year}-${month}-${day}`;
};

// formats given input value (in d.m.Y format) to Y-m-d format
const formatDateInputValue = (inputValue) => {
    if (!inputValue) {
        return;
    }

    const dateArray = inputValue.split('.');
    return `${dateArray[2]}-${dateArray[1]}-${dateArray[0]}`;
}

function desklineFormSubmit(e) {
    e.preventDefault();

    // get fallback dates
    const date = new Date();
    const dateTomorrow = new Date()
    dateTomorrow.setDate(dateTomorrow.getDate() + 1);

    // get values from form
    const
        form = document.querySelector('[data-feratel-quicksearch]'),
        targetUri = form.getAttribute('data-target-uri'),
        localStorageId = form.getAttribute('data-local-storage-id'),
        dateFrom = document.querySelector('[data-feratel-quicksearch\\.date-from]').value
            ? formatDateInputValue(document.querySelector('[data-feratel-quicksearch\\.date-from]').value)
            : formatDate(date),
        dateTo = document.querySelector('[data-feratel-quicksearch\\.date-to]').value
            ? formatDateInputValue(document.querySelector('[data-feratel-quicksearch\\.date-to]').value)
            : formatDate(dateTomorrow),
        numberAdults = document.querySelector('[data-feratel-quicksearch\\.adults]').value,
        numberChildren = document.querySelector('[data-feratel-quicksearch\\.children]').value,
        childArray = [];

    if (numberChildren > 0) {
        for (let i = 1; i <= numberChildren; i++) {
            let ageValue = document.querySelector(`[data-feratel-quicksearch\\.age-child-${i}]`).value;

            if (ageValue !== "" && !isNaN(ageValue)) {
                // Convert to number and add to childArray
                childArray.push(Number(ageValue));
            } else {
                // Convert default value "-" or other invalid values to 0 and add to childArray
                childArray.push(0);
            }
        }
    }

    if (localStorageId && dateFrom && dateTo && numberAdults) {
        dw.accommodationQuickFind (
            localStorageId,

            {
                dateFrom: new Date(dateFrom),
                dateTo: new Date(dateTo),
                occupancy1: {
                    units: 1,
                    adults: numberAdults,
                    children: childArray,
                }
            },

            function() {
                window.location.href = targetUri;
            }
        );

        return false;
    }
}

onPageLoadComplete(async () => {
    const form = document.querySelector('[data-feratel-quicksearch]');

    if (form) {
        form.addEventListener("submit", desklineFormSubmit);
    }
});

/* eslint-enable */
