(window["webpackJsonpLIS"] = window["webpackJsonpLIS"] || []).push([["static-map~toubiz-poi-results-list-controller~vue"],{

/***/ "./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/data/marker.js":
/*!*******************************************************************************!*\
  !*** ./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/data/marker.js ***!
  \*******************************************************************************/
/*! exports provided: Marker */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"Marker\", function() { return Marker; });\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\n/**\n * @typedef {object} Marker~Style\n * @property {string} iconUrl\n * @property {number} width - Width of the marker on the map in pixels\n * @property {number} height - Height of the marker on the map in pixels\n * @property {number} offsetX - X-Position of the tip of the marker image\n * @property {number} offsetY - Y-Position of the tip of the marker image\n */\n\n/**\n * @typedef {object} Marker~Coordinates\n * @property {number} latitude\n * @property {number} longitude\n */\n\n/**\n * @typedef {object} Marker~TourProperties\n * @typedef {number[][]} polygon\n * @typedef {number} difficultyRating\n * @typedef {bool} alwaysDisplayPolygon\n * @typedef {string} color\n */\n\n/**\n * @typedef {object} Marker~Image\n * @typedef {string} url\n * @typedef {string} alt\n */\nvar Marker = function Marker() {\n  _classCallCheck(this, Marker);\n\n  /** @public {string} */\n  this.title = '';\n  /** @public {string} */\n\n  this.description = '';\n  /** @public {string} */\n\n  this.categoryTitle = '';\n  /** @public {string} */\n\n  this.description = '';\n  /** @public {Marker~Image|null} */\n\n  this.image = null;\n  /** @public {string[]} */\n\n  this.paths = [];\n  /** @public {Marker~Style} */\n\n  this.style = {};\n  /** @public {Marker~Style} */\n\n  this.defaultStyle = {};\n  /** @public {Marker~Coordinates} */\n\n  this.coordinates = {\n    latitude: 0,\n    longitude: 0\n  };\n  /** @public {Marker~TourProperties|null} */\n\n  this.tour = null;\n  /** @public {string|null} */\n\n  this.outdoorActiveTrackingId = null;\n  /** @public {string|null} */\n\n  this.url = null;\n  /** @public {Object<string, string>} */\n\n  this.detailApiEndpoints = {};\n  /** @public {Object} */\n\n  this.detail = {};\n};\n\n//# sourceURL=webpack://LIS/./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/data/marker.js?");

/***/ }),

/***/ "./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/abstract-map-with-markers.js":
/*!*************************************************************************************************!*\
  !*** ./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/abstract-map-with-markers.js ***!
  \*************************************************************************************************/
/*! exports provided: AbstractMapWithMarkers */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"AbstractMapWithMarkers\", function() { return AbstractMapWithMarkers; });\nfunction asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }\n\nfunction _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, \"next\", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, \"throw\", err); } _next(undefined); }); }; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\n/**\n * @typedef {object} AbstractMapWithMarkers~Options\n * @property {Marker~Coordinates} center\n * @property {number} zoom - Zoom level from 0 to 100\n * @property {object} clustering\n * @property {string} clustering.color\n * @property {string} clustering.backgroundColor\n * @property {string} clustering.spiderficationIcon\n */\n\n/**\n * Abstract class that must be extended for every map implementation.\n * It provides a bit of common scaffolding such as handling of marker\n * updates.\n *\n * The most important method that must be implemented by subclasses is\n * the `render` method which is called every time something about the map\n * changes and it should be updated.\n *\n * @abstract\n */\nvar AbstractMapWithMarkers = /*#__PURE__*/function () {\n  /**\n   * @param {HTMLElement} node\n   * @param {AbstractMapWithMarkers~Options} options\n   * @param {Observable<Marker[]>} markerProvider\n   */\n  function AbstractMapWithMarkers(node, options) {\n    _classCallCheck(this, AbstractMapWithMarkers);\n\n    /** @protected {HTMLElement} node */\n    this.node = node;\n    /** @protected {AbstractMapWithMarkers~Options} */\n\n    this.options = this.prepareOptions(options);\n    /** @protected {object<string, Function[]>} */\n\n    this.listeners = {\n      markerClick: []\n    };\n  }\n  /**\n   * Method that is called after basic instance variables are set but\n   * before the first render.\n   *\n   * @public\n   * @returns {void}\n   */\n\n\n  _createClass(AbstractMapWithMarkers, [{\n    key: \"initialize\",\n    value: function () {\n      var _initialize = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {\n        return regeneratorRuntime.wrap(function _callee$(_context) {\n          while (1) {\n            switch (_context.prev = _context.next) {\n              case 0:\n              case \"end\":\n                return _context.stop();\n            }\n          }\n        }, _callee);\n      }));\n\n      function initialize() {\n        return _initialize.apply(this, arguments);\n      }\n\n      return initialize;\n    }()\n  }, {\n    key: \"onMarkerClick\",\n    value: function onMarkerClick(callback) {\n      this.listeners.markerClick.push(callback);\n    }\n  }, {\n    key: \"callMarkerClickListeners\",\n    value: function callMarkerClickListeners(marker) {\n      this.listeners.markerClick.forEach(function (cb) {\n        return cb(marker);\n      });\n    }\n    /**\n     * Main rendering method for maps that is called every time something about the\n     * map changes. This method should return a promise (or be async) if the rendering\n     * is done asynchronosly.\n     *\n     * Additionally, it is recommended to use a lock in order to prevent race conditions\n     * when rendering in short sucession.\n     *\n     * @protected\n     * @abstract\n     * @returns {Promise|void}\n     */\n    // eslint-disable-next-line no-unused-vars\n\n  }, {\n    key: \"render\",\n    value: function render() {\n      var markers = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];\n      throw new Error('This method must be implemented by subclasses.');\n    }\n    /**\n     * Centers the current map on all shown markers.\n     * Implement this method if your map supports moving around - don't implement it if it doesn't.\n     *\n     * @public\n     * @param {Marker[]|null} markers\n     * @returns {Promise|void}\n     */\n\n    /* eslint-disable-next-line no-unused-vars */\n\n  }, {\n    key: \"centerMapOnMarkers\",\n    value: function centerMapOnMarkers(markers) {}\n    /**\n     * Prepares the options for usage. This method sets default options or transforms the\n     * incoming options to the correct format.\n     *\n     * Implement this method in your map implementation if there are specific options for your\n     * map that have default values. Don't forget to include a `super` call though.\n     *\n     * @param {object} options\n     * @returns {object}\n     * @protected\n     */\n\n  }, {\n    key: \"prepareOptions\",\n    value: function prepareOptions(options) {\n      options.center = options.center || {\n        latitude: 47.920130,\n        longitude: 7.705250\n      };\n      options.zoom = options.zoom || 80;\n      options.clustering = options.clustering || {};\n      options.clustering.disabled = options.clustering.disabled || false;\n      options.clustering.color = options.clustering.color || 'white';\n      options.clustering.backgroundColor = options.clustering.backgroundColor || '#333';\n      return options;\n    }\n    /**\n     * @public\n     * @param {number} latitude\n     * @param {number} longitude\n     * @returns {Promise}\n     */\n\n  }, {\n    key: \"setCenter\",\n    value: function () {\n      var _setCenter = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(latitude, longitude) {\n        return regeneratorRuntime.wrap(function _callee2$(_context2) {\n          while (1) {\n            switch (_context2.prev = _context2.next) {\n              case 0:\n                this.options.center = {\n                  latitude: latitude,\n                  longitude: longitude\n                };\n                _context2.next = 3;\n                return this.render();\n\n              case 3:\n              case \"end\":\n                return _context2.stop();\n            }\n          }\n        }, _callee2, this);\n      }));\n\n      function setCenter(_x, _x2) {\n        return _setCenter.apply(this, arguments);\n      }\n\n      return setCenter;\n    }()\n    /**\n     * @public\n     * @param {number} zoom\n     * @returns {Promise}\n     */\n\n  }, {\n    key: \"setZoom\",\n    value: function () {\n      var _setZoom = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(zoom) {\n        return regeneratorRuntime.wrap(function _callee3$(_context3) {\n          while (1) {\n            switch (_context3.prev = _context3.next) {\n              case 0:\n                this.options.zoom = zoom;\n                _context3.next = 3;\n                return this.render();\n\n              case 3:\n              case \"end\":\n                return _context3.stop();\n            }\n          }\n        }, _callee3, this);\n      }));\n\n      function setZoom(_x3) {\n        return _setZoom.apply(this, arguments);\n      }\n\n      return setZoom;\n    }()\n  }]);\n\n  return AbstractMapWithMarkers;\n}();\n\n//# sourceURL=webpack://LIS/./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/abstract-map-with-markers.js?");

/***/ }),

/***/ "./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/map-factory.js":
/*!***********************************************************************************!*\
  !*** ./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/map-factory.js ***!
  \***********************************************************************************/
/*! exports provided: initializeMap, setupAutomaticClickHandling */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"initializeMap\", function() { return initializeMap; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"setupAutomaticClickHandling\", function() { return setupAutomaticClickHandling; });\n/* harmony import */ var _common_string_utilities__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../common/string-utilities */ \"./Packages/Plugins/Newland.AssetsNeos/Scripts/common/string-utilities.js\");\n/* harmony import */ var _nimius_dom_utility__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @nimius/dom-utility */ \"./node_modules/@nimius/dom-utility/index.js\");\n/* harmony import */ var _static_google_maps_static__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./static/google-maps-static */ \"./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/static/google-maps-static.js\");\n/* harmony import */ var _static_map_toolkit_static__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./static/map-toolkit-static */ \"./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/static/map-toolkit-static.js\");\n/* harmony import */ var _static_static_dynamic_map_switcher__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./static/static-dynamic-map-switcher */ \"./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/static/static-dynamic-map-switcher.js\");\nfunction _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === \"undefined\" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\nfunction asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }\n\nfunction _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, \"next\", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, \"throw\", err); } _next(undefined); }); }; }\n\n\n\n\n\n\n\nfunction loadGoogleMap() {\n  return __webpack_require__.e(/*! import() */ 4).then(__webpack_require__.bind(null, /*! ./google-maps/google-map */ \"./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/google-maps/google-map.js\")).then(function (mod) {\n    return mod.GoogleMap;\n  });\n}\n\nfunction loadToursprung() {\n  return Promise.all(/*! import() */[__webpack_require__.e(0), __webpack_require__.e(5)]).then(__webpack_require__.bind(null, /*! ./maptoolkit/map-toolkit */ \"./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/maptoolkit/map-toolkit.js\")).then(function (mod) {\n    return mod.MapToolkit;\n  });\n}\n\nfunction loadLeaflet() {\n  return __webpack_require__.e(/*! import() */ 0).then(__webpack_require__.bind(null, /*! ./leaflet/leaflet */ \"./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/leaflet/leaflet.js\")).then(function (mod) {\n    return mod.Leaflet;\n  });\n}\n\nvar implementations = {\n  'google-maps': function googleMaps(mapContainer, options) {\n    return loadGoogleMap().then(function (GoogleMap) {\n      return new GoogleMap(mapContainer, options);\n    });\n  },\n  toursprung: function toursprung(mapContainer, options) {\n    return loadToursprung().then(function (MapToolkit) {\n      return new MapToolkit(mapContainer, options);\n    });\n  },\n  osm: function osm(mapContainer, options) {\n    return loadLeaflet().then(function (Leaflet) {\n      return new Leaflet(mapContainer, options);\n    });\n  },\n  'google-maps-static': function googleMapsStatic(mapContainer, options) {\n    return new _static_google_maps_static__WEBPACK_IMPORTED_MODULE_2__[\"GoogleMapsStatic\"](mapContainer, options);\n  },\n  'toursprung-static': function toursprungStatic(mapContainer, options) {\n    return new _static_map_toolkit_static__WEBPACK_IMPORTED_MODULE_3__[\"MapToolkitStatic\"](mapContainer, options);\n  },\n  'static-dynamic-switch': function staticDynamicSwitch(mapContainer, options) {\n    return new _static_static_dynamic_map_switcher__WEBPACK_IMPORTED_MODULE_4__[\"StaticDynamicMapSwitcher\"](mapContainer, options);\n  }\n};\n/**\n * @param {string} type\n * @param {HTMLElement} mapContainer\n * @param {AbstractMapWithMarkers~Options} options\n * @param {string} fallbackType\n * @returns {AbstractMapWithMarkers}\n */\n\nfunction initializeMap(_x, _x2, _x3) {\n  return _initializeMap.apply(this, arguments);\n}\n/**\n * @param {AbstractMapWithMarkers} map\n */\n\nfunction _initializeMap() {\n  _initializeMap = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(type, mapContainer, options) {\n    var fallbackType,\n        map,\n        _args = arguments;\n    return regeneratorRuntime.wrap(function _callee$(_context) {\n      while (1) {\n        switch (_context.prev = _context.next) {\n          case 0:\n            fallbackType = _args.length > 3 && _args[3] !== undefined ? _args[3] : 'osm';\n            options = options || {};\n\n            if (!implementations[type]) {\n              console.warn(Object(_common_string_utilities__WEBPACK_IMPORTED_MODULE_0__[\"stripMultilineIndention\"])(\"\\n            mapType '\".concat(type, \"' unknown. Using '\").concat(fallbackType, \"'.\\n            Valid mapTypes are [\").concat(Object.keys(implementations).join(', '), \"]\\n        \")));\n              type = fallbackType;\n            }\n\n            _context.next = 5;\n            return implementations[type](mapContainer, options);\n\n          case 5:\n            map = _context.sent;\n            _context.next = 8;\n            return map.initialize();\n\n          case 8:\n            return _context.abrupt(\"return\", map);\n\n          case 9:\n          case \"end\":\n            return _context.stop();\n        }\n      }\n    }, _callee);\n  }));\n  return _initializeMap.apply(this, arguments);\n}\n\nfunction setupAutomaticClickHandling(map) {\n  map.onMarkerClick(function (marker) {\n    if (marker.tour && marker.tour.polygon && marker.tour.polygon.length > 0 && map.drawTourOntoMap) {\n      map.drawTourOntoMap(marker, false);\n    }\n\n    if (marker.contentRenderer && map.openInfoWindow) {\n      marker._markerDom = Object(_nimius_dom_utility__WEBPACK_IMPORTED_MODULE_1__[\"parseStringAsDom\"])(marker.contentRenderer())[0];\n      map.openInfoWindow(marker, marker._markerDom);\n\n      var closeButtons = marker._markerDom.querySelectorAll('[data-toubiz-map-info-window-close-button]');\n\n      var _iterator = _createForOfIteratorHelper(closeButtons),\n          _step;\n\n      try {\n        for (_iterator.s(); !(_step = _iterator.n()).done;) {\n          var closeButton = _step.value;\n          closeButton.addEventListener('click', function () {\n            return map.closeInfoWindow();\n          });\n        }\n      } catch (err) {\n        _iterator.e(err);\n      } finally {\n        _iterator.f();\n      }\n    }\n  });\n}\n\n//# sourceURL=webpack://LIS/./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/map-factory.js?");

/***/ }),

/***/ "./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/static/abstract-static-map.js":
/*!**************************************************************************************************!*\
  !*** ./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/static/abstract-static-map.js ***!
  \**************************************************************************************************/
/*! exports provided: AbstractStaticMap */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"AbstractStaticMap\", function() { return AbstractStaticMap; });\n/* harmony import */ var _abstract_map_with_markers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../abstract-map-with-markers */ \"./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/abstract-map-with-markers.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; if (typeof Symbol === \"function\" && typeof Symbol.iterator === \"symbol\") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === \"function\" && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }; } return _typeof(obj); }\n\nfunction _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === \"undefined\" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\nfunction asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }\n\nfunction _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, \"next\", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, \"throw\", err); } _next(undefined); }); }; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\nfunction _get(target, property, receiver) { if (typeof Reflect !== \"undefined\" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }\n\nfunction _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\n\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } return _assertThisInitialized(self); }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }\n\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\n\n\n/**\n * Small layer that handles common functionality of static maps (e.g. rendering an image)\n * that allows easier implementation of static maps as these only have to generate image\n * urls now.\n *\n * @abstract\n */\n\nvar AbstractStaticMap = /*#__PURE__*/function (_AbstractMapWithMarke) {\n  _inherits(AbstractStaticMap, _AbstractMapWithMarke);\n\n  var _super = _createSuper(AbstractStaticMap);\n\n  function AbstractStaticMap() {\n    _classCallCheck(this, AbstractStaticMap);\n\n    return _super.apply(this, arguments);\n  }\n\n  _createClass(AbstractStaticMap, [{\n    key: \"imageUrl\",\n\n    /**\n     * @param {Marker[]} markers\n     * @param {Object} size\n     * @return {string}\n     * @protected\n     * @abstract\n     */\n    // eslint-disable-next-line\n    value: function imageUrl(markers, size) {\n      throw new Error('This method must be implemented in subclasses');\n    }\n  }, {\n    key: \"initialize\",\n    value: function () {\n      var _initialize = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {\n        return regeneratorRuntime.wrap(function _callee$(_context) {\n          while (1) {\n            switch (_context.prev = _context.next) {\n              case 0:\n                if (this.node.nodeName.toLowerCase() === 'picture') {\n                  this.picture = this.node;\n                } else {\n                  this.picture = document.createElement('picture');\n                  this.node.appendChild(this.picture);\n                }\n\n                this.picture.setAttribute('class', 'block');\n\n              case 2:\n              case \"end\":\n                return _context.stop();\n            }\n          }\n        }, _callee, this);\n      }));\n\n      function initialize() {\n        return _initialize.apply(this, arguments);\n      }\n\n      return initialize;\n    }()\n    /**\n     * @param {Marker[]} markers\n     * @protected\n     */\n\n  }, {\n    key: \"render\",\n    value: function render(markers) {\n      var _iterator = _createForOfIteratorHelper(this.options.srcSet),\n          _step;\n\n      try {\n        for (_iterator.s(); !(_step = _iterator.n()).done;) {\n          var set = _step.value;\n          var source = document.createElement('source');\n          source.setAttribute('srcset', this.imageUrl(markers, set));\n\n          if (set.query) {\n            source.setAttribute('media', set.query);\n          }\n\n          this.picture.appendChild(source);\n        } // Fallback image\n\n      } catch (err) {\n        _iterator.e(err);\n      } finally {\n        _iterator.f();\n      }\n\n      this.image = document.createElement('img');\n      this.picture.appendChild(this.image);\n      this.image.setAttribute('class', 'block');\n      this.image.setAttribute('src', this.imageUrl(markers, this.options));\n    }\n  }, {\n    key: \"prepareOptions\",\n    value: function prepareOptions(options) {\n      options = _get(_getPrototypeOf(AbstractStaticMap.prototype), \"prepareOptions\", this).call(this, options);\n      options.zoom = options.zoom || 85;\n      options.srcSet = options.srcSet || [];\n      return options;\n    }\n  }]);\n\n  return AbstractStaticMap;\n}(_abstract_map_with_markers__WEBPACK_IMPORTED_MODULE_0__[\"AbstractMapWithMarkers\"]);\n\n//# sourceURL=webpack://LIS/./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/static/abstract-static-map.js?");

/***/ }),

/***/ "./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/static/google-maps-static.js":
/*!*************************************************************************************************!*\
  !*** ./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/static/google-maps-static.js ***!
  \*************************************************************************************************/
/*! exports provided: GoogleMapsStatic */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"GoogleMapsStatic\", function() { return GoogleMapsStatic; });\n/* harmony import */ var _common_string_utilities__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../common/string-utilities */ \"./Packages/Plugins/Newland.AssetsNeos/Scripts/common/string-utilities.js\");\n/* harmony import */ var _abstract_static_map__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./abstract-static-map */ \"./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/static/abstract-static-map.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; if (typeof Symbol === \"function\" && typeof Symbol.iterator === \"symbol\") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === \"function\" && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }; } return _typeof(obj); }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _iterableToArrayLimit(arr, i) { if (typeof Symbol === \"undefined\" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\nfunction _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === \"undefined\" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\nfunction _get(target, property, receiver) { if (typeof Reflect !== \"undefined\" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }\n\nfunction _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\n\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } return _assertThisInitialized(self); }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }\n\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\n\n\n\nvar GoogleMapsStatic = /*#__PURE__*/function (_AbstractStaticMap) {\n  _inherits(GoogleMapsStatic, _AbstractStaticMap);\n\n  var _super = _createSuper(GoogleMapsStatic);\n\n  function GoogleMapsStatic() {\n    _classCallCheck(this, GoogleMapsStatic);\n\n    return _super.apply(this, arguments);\n  }\n\n  _createClass(GoogleMapsStatic, [{\n    key: \"prepareOptions\",\n    value: function prepareOptions(options) {\n      options = _get(_getPrototypeOf(GoogleMapsStatic.prototype), \"prepareOptions\", this).call(this, options);\n      options.googleMapStyle = options.googleMapStyle || ['roadmap'];\n\n      if (!options.googleMapsApiKey) {\n        console.warn(Object(_common_string_utilities__WEBPACK_IMPORTED_MODULE_0__[\"stripMultilineIndention\"])(\"\\n                ## Toubiz Map Configuration Warning\\n                No google maps api key supplied\\n            \"));\n      }\n\n      return options;\n    }\n  }, {\n    key: \"imageUrl\",\n    value: function imageUrl(markers, size) {\n      var urlParameters = [\"size=\".concat(size.width, \"x\").concat(size.height), 'scale=2', \"maptype=\".concat(this.options.googleMapStyle[0])];\n\n      if (this.options.googleMapsApiKey) {\n        urlParameters.push(\"key=\".concat(this.options.googleMapsApiKey));\n      }\n\n      var _iterator = _createForOfIteratorHelper(markers),\n          _step;\n\n      try {\n        for (_iterator.s(); !(_step = _iterator.n()).done;) {\n          var marker = _step.value;\n          urlParameters.push(this.markerUrlSegment(marker.coordinates.latitude, marker.coordinates.longitude));\n\n          if (marker.tour && marker.tour.polygon) {\n            var polygon = marker.tour.polygon.map(function (_ref) {\n              var _ref2 = _slicedToArray(_ref, 2),\n                  latitude = _ref2[0],\n                  longitude = _ref2[1];\n\n              return \"\".concat(latitude, \",\").concat(longitude);\n            });\n            urlParameters.push(\"path=color:red|\".concat(polygon.join('|')));\n          }\n        } // Only honor zoom if there is a single marker without a tour.\n        // If there is more, then do not specify zoom (=autozoom)\n\n      } catch (err) {\n        _iterator.e(err);\n      } finally {\n        _iterator.f();\n      }\n\n      if (markers.length === 1 && !markers[0].tour) {\n        urlParameters.push(\"zoom=\".concat(Math.round(this.options.zoom * 18 / 100)));\n      }\n\n      return \"https://maps.googleapis.com/maps/api/staticmap?\".concat(urlParameters.join('&'));\n    }\n  }, {\n    key: \"markerUrlSegment\",\n    value: function markerUrlSegment(latitude, longitude) {\n      var parts = [];\n\n      if (this.options.staticMarkerIconUrl) {\n        parts.push(\"icon:\".concat(encodeURIComponent(this.options.staticMarkerIconUrl)));\n      }\n\n      parts.push(\"\".concat(latitude, \",\").concat(longitude));\n      return \"markers=\".concat(parts.join('|'));\n    }\n  }]);\n\n  return GoogleMapsStatic;\n}(_abstract_static_map__WEBPACK_IMPORTED_MODULE_1__[\"AbstractStaticMap\"]);\n\n//# sourceURL=webpack://LIS/./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/static/google-maps-static.js?");

/***/ }),

/***/ "./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/static/map-toolkit-static.js":
/*!*************************************************************************************************!*\
  !*** ./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/static/map-toolkit-static.js ***!
  \*************************************************************************************************/
/*! exports provided: MapToolkitStatic */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"MapToolkitStatic\", function() { return MapToolkitStatic; });\n/* harmony import */ var _abstract_static_map__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./abstract-static-map */ \"./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/static/abstract-static-map.js\");\n/* harmony import */ var _common_string_utilities__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../common/string-utilities */ \"./Packages/Plugins/Newland.AssetsNeos/Scripts/common/string-utilities.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; if (typeof Symbol === \"function\" && typeof Symbol.iterator === \"symbol\") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === \"function\" && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }; } return _typeof(obj); }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _iterableToArrayLimit(arr, i) { if (typeof Symbol === \"undefined\" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\nfunction _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === \"undefined\" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\nfunction _get(target, property, receiver) { if (typeof Reflect !== \"undefined\" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }\n\nfunction _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\n\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } return _assertThisInitialized(self); }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }\n\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\n\n\n\nvar MapToolkitStatic = /*#__PURE__*/function (_AbstractStaticMap) {\n  _inherits(MapToolkitStatic, _AbstractStaticMap);\n\n  var _super = _createSuper(MapToolkitStatic);\n\n  function MapToolkitStatic() {\n    _classCallCheck(this, MapToolkitStatic);\n\n    return _super.apply(this, arguments);\n  }\n\n  _createClass(MapToolkitStatic, [{\n    key: \"prepareOptions\",\n    value: function prepareOptions(options) {\n      options = _get(_getPrototypeOf(MapToolkitStatic.prototype), \"prepareOptions\", this).call(this, options);\n\n      if (!options.toursprungApiKey) {\n        console.warn(Object(_common_string_utilities__WEBPACK_IMPORTED_MODULE_1__[\"stripMultilineIndention\"])(\"\\n                ## Toubiz Map Configuration Warning\\n                Using toursprung map without API key. Please provide a valid API key.\\n            \"));\n        options.toursprungApiKey = 'sandbox';\n      }\n\n      if (options.staticMarkerIconUrl && options.staticMarkerIconUrl.indexOf('https://') === 0) {\n        console.warn(Object(_common_string_utilities__WEBPACK_IMPORTED_MODULE_1__[\"stripMultilineIndention\"])(\"\\n                ## Toubiz Map Configuration Warning\\n                Toursprung static map icons must be available using http://, not https://.\\n                You supplied \".concat(options.staticMarkerIconUrl, \"\\n            \")));\n      }\n\n      return options;\n    }\n  }, {\n    key: \"imageUrl\",\n    value: function imageUrl(markers, size) {\n      var urlParameters = ['maptype=terrain-v2', \"size=\".concat(size.width, \"x\").concat(size.height), 'factor=2'];\n\n      var _iterator = _createForOfIteratorHelper(markers),\n          _step;\n\n      try {\n        for (_iterator.s(); !(_step = _iterator.n()).done;) {\n          var marker = _step.value;\n          urlParameters.push(this.markerQueryStringPart(marker.coordinates.latitude, marker.coordinates.longitude));\n\n          if (marker.tour && marker.tour.polygon) {\n            var polygon = marker.tour.polygon.map(function (_ref) {\n              var _ref2 = _slicedToArray(_ref, 2),\n                  latitude = _ref2[0],\n                  longitude = _ref2[1];\n\n              return \"\".concat(latitude, \",\").concat(longitude);\n            });\n            urlParameters.push(\"path=color:FF000088|points:\".concat(polygon.join('|')));\n          }\n        } // Only honor zoom if there is a single marker without a tour.\n        // If there is more, then do not specify zoom (=autozoom)\n\n      } catch (err) {\n        _iterator.e(err);\n      } finally {\n        _iterator.f();\n      }\n\n      if (markers.length === 1 && !markers[0].tour) {\n        urlParameters.push(\"zoom=\".concat(Math.round(this.options.zoom * 18 / 100)));\n      }\n\n      return \"https://staticmap.maptoolkit.net/?\".concat(urlParameters.join('&'));\n    }\n  }, {\n    key: \"markerQueryStringPart\",\n    value: function markerQueryStringPart(latitude, longitude) {\n      var parts = [\"center:\".concat(latitude, \",\").concat(longitude)];\n\n      if (this.options.staticMarkerIconUrl) {\n        parts.push(\"icon:\".concat(encodeURIComponent(this.options.staticMarkerIconUrl)));\n      }\n\n      return \"marker=\".concat(parts.join('|'));\n    }\n  }]);\n\n  return MapToolkitStatic;\n}(_abstract_static_map__WEBPACK_IMPORTED_MODULE_0__[\"AbstractStaticMap\"]);\n\n//# sourceURL=webpack://LIS/./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/static/map-toolkit-static.js?");

/***/ }),

/***/ "./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/static/static-dynamic-map-switcher.js":
/*!**********************************************************************************************************!*\
  !*** ./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/static/static-dynamic-map-switcher.js ***!
  \**********************************************************************************************************/
/*! exports provided: StaticDynamicMapSwitcher */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"StaticDynamicMapSwitcher\", function() { return StaticDynamicMapSwitcher; });\n/* harmony import */ var _abstract_map_with_markers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../abstract-map-with-markers */ \"./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/abstract-map-with-markers.js\");\n/* harmony import */ var _map_factory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../map-factory */ \"./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/map-factory.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; if (typeof Symbol === \"function\" && typeof Symbol.iterator === \"symbol\") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === \"function\" && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }; } return _typeof(obj); }\n\nfunction asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }\n\nfunction _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, \"next\", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, \"throw\", err); } _next(undefined); }); }; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\nfunction _get(target, property, receiver) { if (typeof Reflect !== \"undefined\" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }\n\nfunction _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\n\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } return _assertThisInitialized(self); }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }\n\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\n\n\n/**\n * A map renderer that starts out as a dynamic map and converts to a dynamic map on\n * click. The 2 map instances must be passed as constructor arguments.\n */\n\nvar StaticDynamicMapSwitcher = /*#__PURE__*/function (_AbstractMapWithMarke) {\n  _inherits(StaticDynamicMapSwitcher, _AbstractMapWithMarke);\n\n  var _super = _createSuper(StaticDynamicMapSwitcher);\n\n  function StaticDynamicMapSwitcher() {\n    var _this;\n\n    _classCallCheck(this, StaticDynamicMapSwitcher);\n\n    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n      args[_key] = arguments[_key];\n    }\n\n    _this = _super.call.apply(_super, [this].concat(args));\n\n    _defineProperty(_assertThisInitialized(_this), \"static\", true);\n\n    _defineProperty(_assertThisInitialized(_this), \"initializers\", {\n      static: null,\n      dynamic: null\n    });\n\n    _defineProperty(_assertThisInitialized(_this), \"staticMap\", null);\n\n    _defineProperty(_assertThisInitialized(_this), \"dynamicMap\", null);\n\n    _defineProperty(_assertThisInitialized(_this), \"lastRenderedMarkers\", []);\n\n    _defineProperty(_assertThisInitialized(_this), \"lastDrawnTour\", null);\n\n    return _this;\n  }\n\n  _createClass(StaticDynamicMapSwitcher, [{\n    key: \"initialize\",\n    value: function () {\n      var _initialize = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {\n        var _this2 = this;\n\n        return regeneratorRuntime.wrap(function _callee2$(_context2) {\n          while (1) {\n            switch (_context2.prev = _context2.next) {\n              case 0:\n                _context2.next = 2;\n                return Object(_map_factory__WEBPACK_IMPORTED_MODULE_1__[\"initializeMap\"])(this.options.staticMapType, this.node, this.options, 'google-maps-static');\n\n              case 2:\n                this.staticMap = _context2.sent;\n\n                if (!(this.lastRenderedMarkers.length > 0)) {\n                  _context2.next = 6;\n                  break;\n                }\n\n                _context2.next = 6;\n                return this.staticMap.render(this.lastRenderedMarkers);\n\n              case 6:\n                if (!(this.lastDrawnTour && this.staticMap.drawTourOntoMap)) {\n                  _context2.next = 9;\n                  break;\n                }\n\n                _context2.next = 9;\n                return this.staticMap.drawTourOntoMap(this.lastDrawnTour);\n\n              case 9:\n                this.staticMap.picture.addEventListener('click', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {\n                  var size;\n                  return regeneratorRuntime.wrap(function _callee$(_context) {\n                    while (1) {\n                      switch (_context.prev = _context.next) {\n                        case 0:\n                          size = _this2.staticMap.picture.getBoundingClientRect();\n                          _this2.node.style.width = \"\".concat(size.width, \"px\");\n                          _this2.node.style.height = \"\".concat(size.height, \"px\");\n\n                          _this2.staticMap.picture.parentNode.removeChild(_this2.staticMap.picture);\n\n                          _context.next = 6;\n                          return Object(_map_factory__WEBPACK_IMPORTED_MODULE_1__[\"initializeMap\"])(_this2.options.dynamicMapType, _this2.node, _this2.options);\n\n                        case 6:\n                          _this2.dynamicMap = _context.sent;\n\n                          _this2.listeners.markerClick.forEach(function (cb) {\n                            return _this2.dynamicMap.onMarkerClick(cb);\n                          });\n\n                          _context.next = 10;\n                          return _this2.dynamicMap.render(_this2.lastRenderedMarkers);\n\n                        case 10:\n                          if (!(_this2.lastDrawnTour && _this2.dynamicMap.drawTourOntoMap)) {\n                            _context.next = 15;\n                            break;\n                          }\n\n                          _context.next = 13;\n                          return _this2.dynamicMap.drawTourOntoMap(_this2.lastDrawnTour, true);\n\n                        case 13:\n                          _context.next = 16;\n                          break;\n\n                        case 15:\n                          _this2.dynamicMap.centerMapOnMarkers(_this2.lastRenderedMarkers);\n\n                        case 16:\n                        case \"end\":\n                          return _context.stop();\n                      }\n                    }\n                  }, _callee);\n                })));\n\n              case 10:\n              case \"end\":\n                return _context2.stop();\n            }\n          }\n        }, _callee2, this);\n      }));\n\n      function initialize() {\n        return _initialize.apply(this, arguments);\n      }\n\n      return initialize;\n    }()\n  }, {\n    key: \"render\",\n    value: function render() {\n      var markers = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];\n      this.lastRenderedMarkers = markers;\n\n      if (this.static && this.staticMap) {\n        return this.staticMap.render(markers);\n      }\n\n      if (this.dynamicMap) {\n        return this.dynamicMap.render(markers);\n      }\n    }\n  }, {\n    key: \"centerMapOnMarkers\",\n    value: function centerMapOnMarkers(markers) {\n      this.redirectMethodCallToCorrectMapInstance('centerMapOnMarkers', markers);\n    }\n  }, {\n    key: \"setCenter\",\n    value: function setCenter(longitude, latitude) {\n      this.redirectMethodCallToCorrectMapInstance('setCenter', longitude, latitude);\n      return _get(_getPrototypeOf(StaticDynamicMapSwitcher.prototype), \"setCenter\", this).call(this, longitude, latitude);\n    }\n  }, {\n    key: \"setZoom\",\n    value: function setZoom(zoom) {\n      this.redirectMethodCallToCorrectMapInstance('setZoom', zoom);\n      return _get(_getPrototypeOf(StaticDynamicMapSwitcher.prototype), \"setZoom\", this).call(this, zoom);\n    }\n  }, {\n    key: \"drawTourOntoMap\",\n    value: function drawTourOntoMap(tour) {\n      this.lastDrawnTour = tour;\n\n      if (this.static && this.staticMap && this.staticMap.drawTourOntoMap) {\n        this.staticMap.drawTourOntoMap(tour);\n      }\n\n      if (this.dynamicMap && this.dynamicMap.drawTourOntoMap) {\n        this.dynamicMap.drawTourOntoMap(tour);\n      }\n    }\n  }, {\n    key: \"onMarkerClick\",\n    value: function onMarkerClick(callback) {\n      _get(_getPrototypeOf(StaticDynamicMapSwitcher.prototype), \"onMarkerClick\", this).call(this, callback);\n\n      if (this.dynamicMap) {\n        this.dynamicMap.onMarkerClick(callback);\n      }\n    }\n  }, {\n    key: \"redirectMethodCallToCorrectMapInstance\",\n    value: function redirectMethodCallToCorrectMapInstance(methodName) {\n      for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {\n        args[_key2 - 1] = arguments[_key2];\n      }\n\n      if (this.static) {\n        var _this$staticMap;\n\n        return (_this$staticMap = this.staticMap)[methodName].apply(_this$staticMap, args);\n      } else {\n        var _this$dynamicMap;\n\n        return (_this$dynamicMap = this.dynamicMap)[methodName].apply(_this$dynamicMap, args);\n      }\n    }\n  }]);\n\n  return StaticDynamicMapSwitcher;\n}(_abstract_map_with_markers__WEBPACK_IMPORTED_MODULE_0__[\"AbstractMapWithMarkers\"]);\n\n//# sourceURL=webpack://LIS/./Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-map/map/static/static-dynamic-map-switcher.js?");

/***/ })

}]);