/*
 * This scripts allows for dynamic overwrite of the `publicPath` webpack setting.
 * If a global variable `window.__citytheme_public_path__` is set prior to loading the
 * script then the public path will be set to the path specified in that global
 * variable.
 *
 * Example for TPortal integration:
 * <script>
 *   window.__citytheme_public_path__ = "{f:uri.resource(path: 'javascripts/', package: 'Newland.BhuTheme')}";
 * </script>
 * <script src="{f:uri.resource(path: 'javascripts/main.js', package: 'Newland.BhuTheme')}"></script>
 */

// eslint-disable-next-line no-underscore-dangle,no-undef,camelcase
__webpack_public_path__ = window.__citytheme_public_path__ || __webpack_public_path__;