<?php declare(strict_types=1);

namespace Newland\ToubizApi\Tests\Unit\Utility;

use GuzzleHttp\Promise\Promise;
use GuzzleHttp\Promise\RejectedPromise;
use GuzzleHttp\Promise\RejectionException;
use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Api\Utility\MaximumRetriesExceededException;
use Newland\Toubiz\Api\Utility\RetryPool;
use Psr\Log\NullLogger;

class RetryPoolTest extends FunctionalTestCase
{

    /** @var RetryPool */
    protected $subject;

    public function setUp(): void
    {
        parent::setUp();
        $this->subject = new RetryPool(3, 0.01);
        $this->subject->setLogger(new NullLogger());
    }

    public function testRetriesNumberOfTimesOnError(): void
    {
        $count = 0;

        try {
            $this->subject->retryOnException(function() use (&$count) {
                $count++;
                throw new \Exception('test');
            });
        } catch (\Exception $e) {
            $this->assertInstanceOf(MaximumRetriesExceededException::class, $e);
            $this->assertEquals('test', $e->getPrevious()->getMessage());
        }

        $this->assertEquals(3, $count);
    }

    public function testRetriesNumberOfTimesOnPromiseRejection(): void
    {
        $count = 0;

        try {
            $this->subject->retryOnPromiseRejection(function() use (&$count) {
                $count++;
                return new RejectedPromise('test');
            })->wait();
        } catch (\Exception $e) {
            $this->assertInstanceOf(MaximumRetriesExceededException::class, $e);
            $this->assertInstanceOf(RejectionException::class, $e->getPrevious());
        }

        $this->assertEquals(3, $count);
    }

}
