<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Service\Toubiz\Legacy\TourApiService;

use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\EventApiService\MediumAdapter;
use PHPUnit\Framework\TestCase;

class MediumAdapterTest extends TestCase
{

    /** @dataProvider provideUrls */
    public function testMapsUrlCorrectly(array $data, string $expectedSource): void
    {
        $this->assertEquals($expectedSource, (new MediumAdapter($data))->getSourceUri());
    }

    public function provideUrls(): array
    {
        return [
            [
                // url_big is imported if exists
                [
                    'url_big' => 'https://veranstaltungen.toubiz.de/media/event/image/big/1/4/7/6/1476543_06.jpg',
                    'url' => 'https://placehold.it/500x500',
                ],
                'https://veranstaltungen.toubiz.de/media/event/image/big/1/4/7/6/1476543_06.jpg'
            ],
            [
                // url is next in line if url_big is empty
                [
                    'url_big' => '',
                    'url' => 'https://placehold.it/500x500',
                ],
                'https://placehold.it/500x500'
            ],
            [
                // url is next in line if url_big is not a valid url (yes, this happens)
                [
                    'url_big' => 'test_filename.jpg',
                    'url' => 'https://placehold.it/500x500',
                ],
                'https://placehold.it/500x500'
            ],
            [
                // url is next in line if url_big is not a valid url (yes, this happens)
                [
                    'url_big' => '/foo/bar',
                    'url' => 'https://placehold.it/500x500',
                ],
                'https://placehold.it/500x500'
            ],
        ];
    }

}
