<?php
namespace Newland\Toubiz\Api\Tests\Unit\Service\Toubiz\Legacy\Brochure\Parser;

use Newland\Toubiz\Api\Service\Toubiz\Legacy\Brochure\Parser\DeepNestedPropertyParser;
use PHPUnit\Framework\TestCase;

class DeepNestedPropertyParserTest extends TestCase
{

    /**
     * @dataProvider getData
     * @param array $input
     * @param string $suffix
     * @param string $elementSeparator
     * @param string $keySeparator
     * @param array $expected
     */
    public function testParsesData(array $input, string $suffix, string $elementSeparator, string $keySeparator, array $expected)
    {
        $this->assertEquals(
            $expected,
            (new DeepNestedPropertyParser($suffix, $elementSeparator, $keySeparator))->parse($input)
        );
    }

    public function getData(): array
    {
        return [
            [
                [ 'foo' => '33-44', 'foo_pros' => '33|bar-44|baz' ],
                '_pros',
                '-',
                '|',
                [ 'foo' => [ '33' => 'bar', '44' => 'baz' ] ]
            ],
            [
                [ 'foo' => '33--44', 'foo!deepNested' => '33__bar--44__baz' ],
                '!deepNested',
                '--',
                '__',
                [ 'foo' => [ '33' => 'bar', '44' => 'baz' ] ]
            ],
        ];
    }
}
