<?php
namespace Newland\Toubiz\Api\Tests\Unit\Service\Meteotest\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\Weather\DayAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Weather\HourAdapterInterface;

class DayAdapterTest extends MeteoTestAdapterTestCase
{

    public function testReturnsMinimumTemperature()
    {
        // Minimum temperature of andermatt 2018-11-07 in testdata is 4.0 deg
        $day = $this->weatherAdapter('Andermatt')->getForecast()[0];
        $this->assertEquals(4.0, $day->getMinimumTemperature());
    }

    public function testReturnsMaximumTemperature()
    {
        // Maximum temperature of andermatt 2018-11-07 in testdata is 10.2 deg
        $day = $this->weatherAdapter('Andermatt')->getForecast()[0];
        $this->assertEquals(10.2, $day->getMaximumTemperature());
    }

    public function testReturnsTotalSunshineDuration()
    {
        // Sunshine duration of andermatt 2018-11-07 in testdata is 53 minutes
        $day = $this->weatherAdapter('Andermatt')->getForecast()[0];
        $this->assertTrue($day->hasSunshineDurationData());
        $this->assertEquals(53, $day->getSunshineDuration());
    }

    /**
     * @dataProvider provideAllLocationNames
     */
    public function testDatesHaveNoHours(string $location)
    {
        foreach ($this->weatherAdapter($location)->getForecast() as $day) {
            $this->assertEquals('00:00:00', $day->getDate()->format('H:i:s'));
        }
    }

    /**
     * @dataProvider provideAllLocationNames
     */
    public function testHoursReturnsAdapters(string $location)
    {
        foreach ($this->weatherAdapter($location)->getForecast() as $day) {
            foreach ($day->getAllHours() as $hour) {
                $this->assertInstanceOf(HourAdapterInterface::class, $hour);
            }
        }
    }

    /**
     * @dataProvider provideAllLocationNames
     */
    public function testMainHoursReturnsAdapters(string $location)
    {
        foreach ($this->weatherAdapter($location)->getForecast() as $day) {
            foreach ($day->getMainHours() as $hour) {
                $this->assertInstanceOf(HourAdapterInterface::class, $hour);
            }
        }
    }

    /**
     * @dataProvider provideAllLocationNames
     */
    public function testHoursForCalculationReturnsAdapters(string $location)
    {
        foreach ($this->weatherAdapter($location)->getForecast() as $day) {
            foreach ($day->getHoursForCalculation() as $hour) {
                $this->assertInstanceOf(HourAdapterInterface::class, $hour);
            }
        }
    }

    /**
     * @dataProvider provideAllLocationNames
     */
    public function testMainHoursAreInIncrements(string $location)
    {
        foreach ($this->weatherAdapter($location)->getForecast() as $day) {
            foreach ($day->getMainHours() as $mainHour) {
                $this->assertContains(
                    $mainHour->getDate()->format('H'),
                    range(6, 21, 3),
                    'Main hour must be between 6 and 21 in 3-hour increments'
                );
            }
        }
    }

    /**
     * @dataProvider provideAllLocationNames
     */
    public function testHoursForCalculationAreInIncrements(string $location)
    {
        foreach ($this->weatherAdapter($location)->getForecast() as $day) {
            foreach ($day->getHoursForCalculation() as $mainHour) {
                $this->assertContains(
                    $mainHour->getDate()->format('H'),
                    range(0, 23, 6),
                    'Main hour must be between 0 and 23 in 6-hour increments'
                );
            }
        }
    }
}
