<?php

namespace Newland\Toubiz\Api\Tests\Unit\Service\Brochure\ObjectAdapter;

use Newland\Toubiz\Api\Service\Toubiz\Brochures\ObjectAdapter\BrochureAdapter;
use Newland\Toubiz\Api\Service\Toubiz\Brochures\ObjectAdapter\BrochureCategoryAdapter;
use Newland\Toubiz\Api\Service\Toubiz\Brochures\ObjectAdapter\BrochureExternalLinkAdapter;
use Newland\Toubiz\Api\Service\Toubiz\Brochures\ObjectAdapter\BrochureTargetAdapter;

class BrochureAdapterTest extends BrochureAdapterTestCase
{

    /**
     * @dataProvider provideAllBrochures
     */
    public function testReturnsBrochure(int $brochureId)
    {

        $brochure = $this->brochureAdapter($brochureId);
        $this->assertNotEmpty($brochure, 'Not empty');
    }


    /**
     * @dataProvider provideAllBrochures
     */
    public function testReturnsBrochureCategory(int $brochureId)
    {
        $brochure = $this->brochureAdapter($brochureId);
        $this->assertInternalType('array', $brochure->getCategories());
        foreach ($brochure->getCategories() as $category) {
            $this->assertInstanceOf(BrochureCategoryAdapter::class, $category, 'Not a category');
        }
    }

    /**
     * @dataProvider provideAllBrochures
     */
    public function testReturnsBrochureTarget(int $brochureId)
    {
        $brochure = $this->brochureAdapter($brochureId);
        $this->assertInternalType('array', $brochure->getTargets());
        foreach ($brochure->getTargets() as $target) {
            $this->assertInstanceOf(BrochureTargetAdapter::class, $target, 'Not a target');
        }
    }

    /**
     * @dataProvider provideAllBrochures
     */
    public function testReturnsBrochureExternalLinks(int $brochureId)
    {
        $brochure = $this->brochureAdapter($brochureId);
        $this->assertInternalType('array', $brochure->getExternalLinks());
        foreach ($brochure->getExternalLinks() as $link) {
            $this->assertInstanceOf(BrochureExternalLinkAdapter::class, $link, 'Not a target');
        }
    }

    /**
     * @dataProvider provideAllBrochures
     */
    public function testReturnsBrochureFlagStatus(int $brochureId)
    {
        $brochure = $this->brochureAdapter($brochureId);
        $this->assertNotEmpty($brochure->getFlagStatus(), 'Empty Flag Status');
    }

    public function testInvalidFlagStatus()
    {
        $brochure = new BrochureAdapter([ 'flag_status' => 'foo' ]);

        $this->assertEquals(1, $brochure->getFlagStatus());
    }
}
