<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Tportal\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\StarRatingAdapterInterface;
use Psr\Log\LoggerAwareTrait;

class StarRatingAdapter extends AbstractObjectAdapter implements StarRatingAdapterInterface
{
    use LoggerAwareTrait;

    /** @var string */
    protected $baseUrl = 'https://tportal.toubiz.de/default/ng/img/stars/';

    public function getExternalId(): string
    {
        return $this->object['twsLookupValues']['externalID'];
    }

    public function getValue(): int
    {
        // e.g. for multiple apartments within 1 apartment complex
        $classificationString = (string) ($this->object['twsLookupValues']['value'] ?? '');

        // Parse actual numbers
        if (preg_match('/^\d$/', $classificationString)) {
            return (int) $classificationString;
        }

        // parse the int value of rating string like "5 Sterne Superior"
        if (preg_match('/^(\d)[\s|\-].*/', $classificationString, $matches)) {
            return (int) $matches[1];
        }

        // Parse int data such as F*** as 3 stars (number of stars in the string)
        if (preg_match('/(\*+)/', $classificationString, $matches)) {
            return \strlen($matches[1]);
        }

        return -1;
    }

    public function getLabel(): string
    {
        return strip_tags((string) ($this->object['twsLookupValues']['value'] ?? ''));
    }

    private function getBadgeImage(string $id): ?string
    {
        $ratingInfo = $this->object['ratings_map'][$id] ?? null;

        if ($ratingInfo && $ratingInfo->type !== 'none') {
            return $ratingInfo->image;
        }

        if (!$ratingInfo && !empty($id)) {
            $this->logger->warning(sprintf('Cannot find badge image for rating `%s`', $id));
        }

        return null;
    }

    public function getBadgeUrl(): ?string
    {
        $id = (string) ($this->object['twsLookupValues']['externalID'] ?? '');
        $imageFileName = $this->getBadgeImage($id);

        if ($imageFileName) {
            return $this->baseUrl . $imageFileName;
        } else {
            return null;
        }
    }
}
