<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\TourApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\FileAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

/**
 * File adapter.
 *
 * This one is specifically for the toubiz tour endpoint.
 */
class FileAdapter extends AbstractLegacyObjectAdapter implements FileAdapterInterface
{
    public function __construct(string $name, string $path)
    {
        parent::__construct(
            [
                'name' => $name,
                'path' => $path,
            ]
        );
    }

    /**
     * @return string
     */
    public function getExternalId(): string
    {
        // There is not really an id for this.
        return md5($this->object['path'] . $this->object['path']);
    }

    /**
     * @return string
     */
    public function getName()
    {
        return (string) $this->object['name'];
    }

    /**
     * @return string
     */
    public function getSourceUri()
    {
        return (string) $this->object['path'];
    }
}
