<?php declare(strict_types = 1);
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\TourApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\Constants\EntityType;
use Newland\Toubiz\Api\ObjectAdapter\RelatedLists\ArticleListAdapterInterface;
use Newland\Toubiz\Api\Service\WithUuidPredictionService;

class ArticleListAdapter implements ArticleListAdapterInterface
{
    use WithUuidPredictionService;

    /**
     * @var string
     */
    protected $title;
    /**
     * @var array
     */
    protected $articleIdentifiers;
    /**
     * @var array
     */
    protected $categoryIdentifiers;

    public function __construct(string $title, array $articleIdentifiers, array $categoryIdentifiers)
    {
        $this->title = $title;
        $this->articleIdentifiers = $articleIdentifiers;
        $this->categoryIdentifiers = $categoryIdentifiers;
    }

    public function getTitle(): string
    {
        return strip_tags((string) $this->title);
    }

    public function getArticleIdentifiers(): array
    {
        return array_map(function (string $id) {
            return $this->uuidPredictionService->predictForType(EntityType::ARTICLE, ['originalId' => $id]);
        }, $this->articleIdentifiers);
    }

    public function getCategoryIdentifiers(): array
    {
        return array_map(function (string $id) {
            return $this->uuidPredictionService->predictForType(EntityType::CATEGORY, ['originalId' => $id]);
        }, $this->categoryIdentifiers);
    }

    public function hasItems(): bool
    {
        return \count($this->articleIdentifiers) !== 0 || \count($this->categoryIdentifiers) !== 0;
    }
}
