<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\DbService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\CategoryAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

/**
 * Category adapter.
 *
 * This one is specifically for the db service.
 */
class CategoryAdapter extends AbstractLegacyObjectAdapter implements CategoryAdapterInterface
{
    /**
     * @return string
     */
    public function getExternalId(): string
    {
        return strip_tags((string) $this->object['remote_id']);
    }

    /**
     * @return string
     */
    public function getName()
    {
        return strip_tags((string) $this->object['name']);
    }
}
