<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\Brochure\Parser;

/**
 * Parser for key/value pairs that are separated by special separator strings.
 *
 * - An element separator of '|' and a key separator of '_' is able to parse the following string:
 *   'key1_value1|key2_value2'
 *
 * - An element separator of '!' and a key separator of ',' is able to  parse the following string:
 *   'key1,value1!key2,value2'
 */
class SimpleKeyValueParser
{
    /** @var string */
    private $elementSeparator;

    /** @var string */
    private $keySeparator;

    public function __construct(string $elementSeparator, string $keySeparator)
    {
        $this->elementSeparator = $elementSeparator;
        $this->keySeparator = $keySeparator;
    }

    public function parse(string $string): array
    {
        $parts = explode($this->elementSeparator, $string);
        if ($parts === false) {
            return [];
        }

        $array = [];
        foreach ($parts as $index => $part) {
            $keyAndValue = explode($this->keySeparator, $part, 2);
            if ($keyAndValue === false) {
                continue;
            }

            if (\count($keyAndValue) === 1) {
                $key = $index;
                $value = $keyAndValue[0];
            } else {
                list( $key, $value ) = $keyAndValue;
            }

            $keyAlreadyExists = array_key_exists($key, $array);
            if (!empty($value) && !$keyAlreadyExists) {
                $array[$key] = $value;
            }
        }

        return $array;
    }
}
