<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Brochures\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\BrochureAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;
use Newland\Toubiz\Api\Service\Toubiz\Brochures\ObjectAdapter\BrochureCategoryAdapter;

class BrochureAdapter extends AbstractLegacyObjectAdapter implements BrochureAdapterInterface
{

    public function getExternalId(): string
    {
        return strip_tags((string) $this->object['id_prospekt']);
    }

    public function getLastChange(): \DateTime
    {
        return new \DateTime($this->object['last_change']);
    }

    public function getTitle(): string
    {
        return strip_tags((string) ($this->object['title'] ?? ''));
    }

    public function getDescription(): string
    {
        return (string) ($this->object['description'] ?? '');
    }

    public function getType(): string
    {
        return strip_tags((string) ($this->object['type'] ?? ''));
    }

    public function getWeight(): float
    {
        return (float) ($this->object['weight'] ?? 0);
    }

    public function getFlagStatus(): int
    {
        $default = 1;
        $flag = explode('#', $this->object['flag_status']);
        if (\count($flag) < 2) {
            return $default;
        }

        $status = (int) $flag[0];
        if (!in_array($status, [1, 2, 3, 4])) {
            return $default;
        }

        return $status;
    }

    public function getProspectCount(): int
    {
        return (int) ($this->object['prospekt_count'] ?? 0);
    }

    public function getSize(): string
    {
        return strip_tags((string) ($this->object['size'] ?? ''));
    }

    /**
     * @return string
     */
    public function getAddress(): string
    {
        return $this->object['address'] ?? '';
    }

    public function getLocations(): array
    {
        return $this->object['location'] ?? [];
    }

    public function getRegion(): array
    {
        return $this->object['region'] ?? [];
    }

    public function getLanguages(): array
    {
        return $this->object['language'] ?? [];
    }

    /**
     * @return BrochureCategoryAdapter[]
     */
    public function getCategories(): array
    {

        return array_map(
            function ($item) {
                return (new BrochureCategoryAdapter($item));
            },
            (array) $this->object['category']
        );
    }

    /**
     * @return BrochureTargetAdapter[]
     */
    public function getTargets(): array
    {
        return array_map(
            function ($item) {
                return (new BrochureTargetAdapter($item));
            },
            (array) $this->object['target']
        );
    }

    public function getImages(): array
    {
        return $this->object['images']['tbImageProspekt'] ?? [];
    }

    public function getFiles(): array
    {
        return $this->object['file'] ?? [];
    }

    /**
     * @return BrochureExternalLinkAdapter[]
     */
    public function getExternalLinks(): array
    {
        return array_map(
            function ($item) {
                return (new BrochureExternalLinkAdapter($item));
            },
            (array) $this->object['deeplink']
        );
    }
}
